/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit.fn;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.ScriptFunction;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UrlEncode
implements ScriptFunction {
    public static final String name = "urlEncode";

    @Override
    public Value apply(List<? extends Value> args) throws ScriptEvaluationException {
        Value v;
        try {
            v = args.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ScriptEvaluationException("urlEncode requires one argument");
        }
        return new Value(){

            @Override
            public String on(Map<Integer, String> m) throws ScriptEvaluationException {
                return UrlEncode.encode(v.on(m));
            }

            @Override
            public String on(DicomObject o) throws ScriptEvaluationException {
                return UrlEncode.encode(v.on(o));
            }

            @Override
            public Set<Variable> getVariables() {
                return v.getVariables();
            }

            @Override
            public SortedSet<Long> getTags() {
                return v.getTags();
            }

            @Override
            public void replace(Variable var) {
                v.replace(var);
            }
        };
    }

    private static String encode(String s) {
        try {
            return null == s ? null : URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

