/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.io;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.DicomUtils;
import org.nrg.dcm.edit.Action;
import org.nrg.dcm.edit.Statement;
import org.nrg.dcm.io.DicomObjectExporter;
import org.nrg.util.CanceledOperationException;
import org.nrg.util.EditProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchExporter
implements Runnable {
    private static final Exception canceledException = new CanceledOperationException();
    private final Logger logger = LoggerFactory.getLogger(BatchExporter.class);
    private final DicomObjectExporter objectExporter;
    private final List<Statement> statements;
    private final Iterator<?> toExport;
    private EditProgressMonitor pm = null;
    private int progress = -1;
    private final Map<Object, Throwable> failures = Maps.newLinkedHashMap();
    private boolean isPending = true;

    public BatchExporter(DicomObjectExporter objectExporter, Iterable<Statement> statements, Iterator<?> toExport) {
        this.objectExporter = objectExporter;
        this.statements = Lists.newArrayList(statements);
        Collections.reverse(this.statements);
        this.toExport = toExport;
    }

    public BatchExporter(DicomObjectExporter objectExporter, List<Statement> statements, Iterable<?> toExport) {
        this(objectExporter, statements, toExport.iterator());
    }

    public void setProgressMonitor(EditProgressMonitor pm, int progress) {
        this.pm = pm;
        this.progress = progress;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public Map<?, Throwable> getFailures() {
        if (this.isPending) {
            throw new IllegalStateException("export not yet complete");
        }
        return this.failures;
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public void run() {
        EditProgressMonitor pm = this.pm;
        while (this.toExport.hasNext()) {
            DicomObject o;
            File f;
            Object t;
            block18: {
                t = this.toExport.next();
                if (null != pm) {
                    if (pm.isCanceled()) {
                        this.failures.put(t, canceledException);
                        while (this.toExport.hasNext()) {
                            this.failures.put(this.toExport.next(), canceledException);
                        }
                        this.isPending = true;
                        return;
                    }
                    pm.setNote(t.toString());
                }
                this.logger.trace("Checking {}", t);
                try {
                    if (t instanceof File) {
                        f = (File)t;
                        o = DicomUtils.read((File)f);
                        break block18;
                    }
                    if (t instanceof URI) {
                        URI uri = (URI)t;
                        if ("file".equals(uri.getScheme())) {
                            f = new File(uri);
                            o = DicomUtils.read((File)f);
                        } else {
                            f = null;
                            o = DicomUtils.read((URI)uri);
                        }
                        break block18;
                    }
                    if (t instanceof DicomObject) {
                        f = null;
                        o = (DicomObject)t;
                        break block18;
                    }
                    this.failures.put(t, new IllegalArgumentException("cannot export class " + t.getClass().getName()));
                }
                catch (Throwable e) {
                    this.logger.debug("load failed for " + t, e);
                    this.failures.put(t, e);
                }
                continue;
            }
            try {
                for (Action a : Statement.getActions(this.statements, f, o)) {
                    a.apply();
                }
            }
            catch (Throwable e) {
                this.logger.debug("script application failed for " + t, e);
                this.failures.put(t, e);
            }
            try {
                this.logger.trace("exporting {}", t);
                this.objectExporter.export(o, f);
                ++this.progress;
                if (null == pm) continue;
                pm.setProgress(this.progress);
            }
            catch (Throwable e) {
                this.logger.debug("export failed for " + t, e);
                this.failures.put(t, e);
            }
        }
        this.objectExporter.close();
        if (null != pm) {
            pm.close();
        }
        this.logger.debug("Export completed");
        if (!this.failures.isEmpty()) {
            this.logger.debug("Failures: {}", this.failures);
        }
        this.isPending = false;
    }
}

