/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.io;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.TransferCapability;
import org.nrg.dcm.DicomUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransferCapabilityExtractor {
    private static final TransferCapability[] EMPTY_TC_ARRAY = new TransferCapability[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Predicate<String> notNull = Predicates.notNull();

    private TransferCapabilityExtractor() {
    }

    public static TransferCapability[] getTransferCapabilities(Iterator<File> files, String role) {
        LinkedHashMultimap tcElements = LinkedHashMultimap.create();
        while (files.hasNext()) {
            File f = files.next();
            try {
                DicomObject o = DicomUtils.read((File)f, (int)524310);
                tcElements.put((Object)o.getString(524310), (Object)DicomUtils.getTransferSyntaxUID((DicomObject)o));
            }
            catch (IOException skip) {}
        }
        return TransferCapabilityExtractor.getTransferCapabilities((SetMultimap<String, String>)tcElements, role);
    }

    public static TransferCapability[] getTransferCapabilities(Iterable<File> files, String role) {
        return TransferCapabilityExtractor.getTransferCapabilities(files.iterator(), role);
    }

    public static TransferCapability[] getTransferCapabilities(SetMultimap<String, String> sopToTS, String role) {
        ArrayList tcs = Lists.newArrayListWithCapacity((int)sopToTS.size());
        for (String sop : sopToTS.keySet()) {
            Set tsuids = Sets.filter((Set)sopToTS.get((Object)sop), notNull);
            if (tsuids.isEmpty()) continue;
            tcs.add(new TransferCapability(sop, tsuids.toArray(EMPTY_STRING_ARRAY), role));
        }
        return tcs.toArray(EMPTY_TC_ARRAY);
    }
}

