/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.nrg.util.EditProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWalkIterator
implements Iterator<File> {
    private static final RuntimeException NEXT_NOT_CALLED = new IllegalStateException("next() not called");
    private static final int PATHMAX = 2048;
    private static final Iterator<File> EMPTY = Iterators.emptyIterator();
    private final Logger logger = LoggerFactory.getLogger(FileWalkIterator.class);
    private final Queue<File> files = Lists.newLinkedList();
    private final Queue<File> dirs = Lists.newLinkedList();
    private final Iterator<File> input;
    private Object current = NEXT_NOT_CALLED;
    private int count;
    private int known;
    private final EditProgressMonitor progress;

    public FileWalkIterator(Iterator<File> i, EditProgressMonitor progress) {
        this.progress = progress;
        this.input = i;
        this.count = 0;
        if (null != progress) {
            progress.setMinimum(0);
            this.known = i.hasNext() ? 1 : 0;
            progress.setMaximum(this.known);
        }
    }

    public FileWalkIterator(File root, EditProgressMonitor progress) {
        this(EMPTY, progress);
        (root.isDirectory() ? this.dirs : this.files).add(root);
        if (null != progress) {
            this.known = 1;
            progress.setMaximum(1);
        }
    }

    public FileWalkIterator(Iterable<File> i, EditProgressMonitor progress) {
        this(i.iterator(), progress);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareQueue() {
        while (this.files.isEmpty()) {
            if (this.dirs.isEmpty()) {
                if (!this.input.hasNext()) return;
                File f = this.input.next();
                if (f.isDirectory()) {
                    this.dirs.add(f);
                } else {
                    this.files.add(f);
                    return;
                }
            }
            assert (this.files.isEmpty());
            assert (!this.dirs.isEmpty());
            File d = this.dirs.remove();
            File[] contents = d.listFiles();
            if (null == contents) {
                this.logger.info("directory {} returned null listing", (Object)d);
            } else {
                this.logger.debug("reading directory {}", (Object)d);
                if (null != this.progress) {
                    this.progress.setNote("reading contents of " + d.getPath());
                    this.progress.setMaximum(this.known += contents.length);
                }
                for (int i = 0; i < contents.length; ++i) {
                    File f = contents[i];
                    if (f.isDirectory()) {
                        if (f.getPath().length() > 2048) {
                            this.logger.info("skipping deep directory {} to avoid symlink cycle", (Object)f);
                            ++this.count;
                            continue;
                        }
                        this.dirs.add(f);
                        continue;
                    }
                    this.files.add(f);
                }
            }
            ++this.count;
            if (null == this.progress) continue;
            this.progress.setProgress(this.count);
        }
    }

    @Override
    public boolean hasNext() {
        this.prepareQueue();
        return !this.files.isEmpty();
    }

    @Override
    public File next() {
        this.prepareQueue();
        if (this.files.isEmpty()) {
            throw new NoSuchElementException();
        }
        ++this.count;
        if (null != this.progress) {
            this.progress.setProgress(this.count);
        }
        this.current = this.files.remove();
        return this.current;
    }

    public File nextFile() {
        return this.next();
    }

    @Override
    public void remove() {
        if (NEXT_NOT_CALLED == this.current) {
            throw NEXT_NOT_CALLED;
        }
        File f = (File)this.current;
        assert (!f.isDirectory());
        if (!f.delete()) {
            this.logger.debug("failed to delete {}", (Object)f);
        }
    }

    public int getCount() {
        return this.count;
    }
}

