/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io;

import com.google.common.base.Function;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PresuffixFileMapper
implements Function<File, File> {
    private final String presuffix;

    public PresuffixFileMapper(String presuffix) {
        this.presuffix = presuffix;
    }

    public File apply(File original) {
        File dir = original.getParentFile();
        StringBuilder name = new StringBuilder(original.getName());
        int presuffixLoc = name.lastIndexOf(".");
        if (presuffixLoc < 0) {
            name.append(this.presuffix);
        } else {
            name.insert(presuffixLoc, this.presuffix);
        }
        return new File(dir, name.toString());
    }
}

